import java.io.*;
import java.awt.*;

/** Drawing a wall of bricks */
public class Bricks extends Frame {
  private int rowLength;      // number of bricks in a row 
  private int height;         // number of rows of bricks
  
  private int heightbrick= 8; // height of a brick in pixels
  private int widthbrick= 20; // width of a brick in pixels
  private int heightspace= 2; // number of pixels between rows
  private int widthspace= 2;  // number of pixels between adjacent bricks in a row
 
  /** Set the number of bricks in a row to t */
  public void setRowSize(int t) {
     rowLength= t;
  }
  
  /** Set the height of the wall to t bricks */
  public void setHeight(int t) {
     height= t;
  }

  /** A wall consisting of height rows, each with rowLength bricks */
  public void paint(Graphics g) {
     g.translate(getInsets().left, getInsets().top);
     g.setColor(Color.red);
     int hx= 2;
     int vx= 2;
     
     drawRow(hx, vx, g);
     /* Process 0..n-1
        int k= 0;
        // Invariant: 0..k-1 has been processed
        while (k != n) {
           Process k
            
           k= k+1;
        }
     */
   }
   
   /** Draw a row of rowLength bricks with upper left pixel (x,y)
       Each brick is hbrick pixels high and wbrick pixels wide.
       There are hspace pixels between each row and
       wspace pixels between adjacent bricks */
   public void drawRow(int x, int y, Graphics g) {
       g.drawRect(x, y, widthbrick, heightbrick);
       /* // Process integers 0..n-1
          // int k= 0;
          // invariant: Process k
          while (k != n) {
             Process k;
  	         
  	         k= k+1;
          }
       */
   }
}
